/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat;

import java.util.LinkedList;
import java.util.List;
import net.creeperhost.minetogether.lib.chat.message.Message;
import net.creeperhost.minetogether.util.MessageFormatter;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public abstract class DisplayableMessage<M> {
    private final Minecraft mc = Minecraft.m_91087_();
    private final Message message;
    private final Object listener;
    private final List<M> trimmedLines = new LinkedList<M>();
    @Nullable
    private GuiMessage<Component> builtMessage;
    private boolean dirty;

    protected DisplayableMessage(Message message) {
        this.message = message;
        this.listener = message.addListener(this, (i, e) -> {
            i.dirty = true;
            i.onModified();
        });
    }

    public void onDead() {
        this.message.removeListener(this.listener);
    }

    public void display() {
        this.format();
        this.insertAt(0);
    }

    public void format() {
        int addTime = this.builtMessage != null ? this.builtMessage.m_90794_() : this.mc.f_91065_.m_93079_();
        this.builtMessage = new GuiMessage(addTime, (Object)MessageFormatter.formatMessage(this.message), 0);
        this.trimmedLines.clear();
        int maxLen = Mth.m_14107_((double)this.getChatWidth());
        List lines = ComponentRenderUtils.m_94005_((FormattedText)((FormattedText)this.builtMessage.m_90793_()), (int)maxLen, (Font)this.mc.f_91062_);
        for (FormattedCharSequence line : lines) {
            this.trimmedLines.add(this.createMessage(addTime, line));
        }
        assert (!this.trimmedLines.isEmpty());
    }

    public List<M> getTrimmedLines() {
        return this.trimmedLines;
    }

    @Nullable
    public Component getBuiltMessage() {
        return (Component)this.builtMessage.m_90793_();
    }

    public Message getMessage() {
        return this.message;
    }

    public void reformat() {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        if (this.builtMessage == null) {
            return;
        }
        int trimmedIdx = this.getMessageIndex(this.isForward() ? this.trimmedLines.get(0) : this.trimmedLines.get(this.trimmedLines.size() - 1));
        this.clearMessages();
        this.format();
        this.insertAt(trimmedIdx);
    }

    private void insertAt(int trimmedIdx) {
        for (M trimmedLine : this.trimmedLines) {
            this.addMessage(trimmedIdx, trimmedLine);
        }
    }

    protected abstract void onModified();

    protected abstract boolean isForward();

    protected abstract M createMessage(int var1, FormattedCharSequence var2);

    protected abstract int getMessageIndex(M var1);

    protected abstract void clearMessages();

    protected abstract void addMessage(int var1, M var2);

    protected abstract double getChatWidth();
}

